<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package _tk
 */

get_header();

$blog_columns = get_field('blog_columns','option'); ?>

	<div class="container margintop main-content">
		
		<?php if (get_field('news_title','option')) { ?>
			<?php if (!get_field('section_left','option')) { ?>
				<div class="text-center">
			<?php } ?>
				<h3 class="page-title<?php if (get_field('section_title_border','option')) echo ' relative title-border'; ?><?php if (get_field('more_padding','option')) echo ' more-padding'; ?><?php if (get_field('section_left','option')) echo ' text-left'; ?>"><span><?php the_field('news_title','option'); ?></span></h3>
			<?php if (!get_field('section_left','option')) { ?>
				</div>
			<?php } ?>
		<?php } ?>
		<div class="row">
			<?php if (get_field('show_sidebar','option')) { ?>
				<div class="col-sm-18<?php if (get_field('sidebar_position','option') == 'left') echo ' col-sm-push-6'; ?>">
			<?php } else { ?>
				<div class="col-sm-24">
			<?php } ?>
					<?php if ( have_posts() ) : ?>
						<div class="<?php if (get_field('blog_type','option') == 'masonry') echo ' grid grid-'.$blog_columns; else echo 'row'; ?>">
							<?php if (get_field('blog_type','option') == 'masonry') { ?>
								<div class="grid-sizer"></div>
								<div class="gutter-sizer"></div>
							<?php } ?>
							<?php $del = 100;
							while ( have_posts() ) : the_post(); ?>

								<?php get_template_part( 'elements/content', get_post_format() ); ?>
								
							<?php $del = $del + 150;
							endwhile; ?>
						</div>

						<?php _tk_content_nav( 'nav-below' ); ?>
						<?php _tk_pagination(); ?>

					<?php else : ?>

						<?php get_template_part( 'no-results', 'index' ); ?>

					<?php endif; ?>
				</div>

			<?php if (get_field('show_sidebar','option')) { ?>
				<div class="col-sm-6<?php if (get_field('sidebar_position','option') == 'left') echo ' col-sm-pull-18'; ?>">
					<?php get_sidebar(); ?>
				</div>
			<?php } ?>
		</div>
	</div>
<?php get_footer(); ?>